<?php
$map = @join("", @file('map-test.txt'));
$dummy = explode("\n", $map);
$map = str_replace("\n", ":", $map);
$map = str_replace("\r", "", $map);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Pr&eacute;lude Prod - Exemple E - plugin jQuery : pp3Diso</title>
<meta name="author" content="" />
<meta name="description" content="" />
<meta name="keywords" content="" />
<meta name="language" content="fr" />
<meta name="robots" content="all" />
<link href="css/styles.css" rel="stylesheet" type="text/css" />
<link href="css/pp3diso.css" rel="stylesheet" type="text/css" />
<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico" />
<link rel="icon" type="image/png" href="/favicon.png" />
<script src="http://code.jquery.com/jquery-1.6.4.min.js" type="text/javascript"></script>
<script src="../jquery.pp3Diso.min.js" type="text/javascript"></script>
</head>
<body>
<div id="total">
<div id="show">
</div>
<div id="interface">
	<a href="javascript:change_cursor(1);"><img src="images/map-2.png" alt="" width="64" height="40" /></a>
	<a href="javascript:change_cursor(2);"><img src="images/map-3.png" alt="" width="64" height="40" /></a>
	<a href="javascript:change_cursor(7);"><img src="images/map-4.png" alt="" width="64" height="40" /></a>
	<a href="javascript:change_cursor(8);"><img src="images/map-5.png" alt="" width="64" height="40" /></a>
	<hr />
	<a href="javascript:change_cursor(3);"><img src="images/rock-1.png" alt="" width="64" height="64" /></a>
	<a href="javascript:change_cursor(6);"><img src="images/rock-2.png" alt="" width="64" height="64" /></a>
	<a href="javascript:change_cursor(4);"><img src="images/xtree.png" alt="" width="64" height="45" /></a>
	<a href="javascript:change_cursor(5);"><img src="images/tree.png" alt="" width="93" height="122" /></a>
</div>
<div id="carte">
	<div id="resultat">
		<a href="javascript:save()">Save</a>
	</div>

	<div id="ppISO">
		<div id="loupe-plus" class="pp3diso_users"><a href="javascript:zoom_plus();"><img src="images/loupe-plus.png" width="44" height="45" alt="" /></a></div>
		<div id="loupe-moins" class="pp3diso_users"><a href="javascript:zoom_moins();"><img src="images/loupe-moins.png" width="44" height="45" alt="" /></a></div>
		<div id="pp3diso-fleche-s" class="pp3diso_users fleche"></div>
		<div id="pp3diso-fleche-n" class="pp3diso_users fleche"></div>
		<div id="pp3diso-fleche-e" class="pp3diso_users fleche"></div>
		<div id="pp3diso-fleche-o" class="pp3diso_users fleche"></div>
		
		<div id="pp3diso-fleche-se" class="pp3diso_users fleche"></div>
		<div id="pp3diso-fleche-ne" class="pp3diso_users fleche"></div>
		<div id="pp3diso-fleche-so" class="pp3diso_users fleche"></div>
		<div id="pp3diso-fleche-no" class="pp3diso_users fleche"></div>
	</div>
</div>
</div>
<script type="text/JavaScript">
<!--
var ppmap;
var zoom = 1;
window.onload = function() {
	ppmap = $('#ppISO').pp3Diso({
		map:'<?php echo $map; ?>',		// la map
		mapId:1,				// id de la map
		nbrTitleSetsSlide:100,		// pas de mouvement de la map lorsque l'on click dessus
		tx:64,					// dimension x des tuiles
		ty:40,					// dimension y des tuiles
		prefix:'map-',
		auto_size:false,
		mousewheel:true,
		onmoveavatar:function(x, y, id) {
			myClick(x, y, id);
		}
	});
	ppmap.moveMapOn();
	ppmap.cursor('images/cursor-on.png', 'images/cursor-off.png', 0, 0);

	
}

var Choix = 0;
var objets = new Array();
var objetsDecX = new Array();
var objetsDecY = new Array();
objets[1] = '2';
objetsDecX[1] = 0;
objetsDecY[1] = 0;

objets[2] = '3';
objetsDecX[2] = 0;
objetsDecY[2] = 0;

objets[3] = 'rock-1.png';
objetsDecX[3] = 0;
objetsDecY[3] = -30;

objets[4] = 'xtree.png';
objetsDecX[4] = 0;
objetsDecY[4] = -5;

objets[5] = 'tree.png';
objetsDecX[5] = -15;
objetsDecY[5] = -90;

objets[6] = 'rock-2.png';
objetsDecX[6] = 0;
objetsDecY[6] = -30;

objets[7] = '4';
objetsDecX[7] = 0;
objetsDecY[7] = 0;

objets[8] = '5';
objetsDecX[8] = 0;
objetsDecY[8] = 0;

function change_cursor(n) {
	if(IsNumeric(objets[n])) {
		ppmap.changeCursor('images/map-' + objets[n] + '.png', 'images/cursor-off.png', objetsDecX[n], objetsDecY[n]);
	}else{
		ppmap.changeCursor('images/' + objets[n], 'images/cursor-off.png', objetsDecX[n], objetsDecY[n]);
	}
	Choix = n;
}

function myClick(x, y, id) {
	switch(Choix) {
		case 1:
		case 2:
		case 7:
		case 8:
			ppmap.changeOneMap(x, y, objets[Choix]);
			break;
		case 3:
		case 4:
		case 5:
		case 6:
			ppmap.addObject(x, y, 'images/' + objets[Choix], objetsDecX[Choix], objetsDecY[Choix]);
			break;
	}
}


function gestion_tip_off(x, y, idMap) {
	ppmap.tipHide();
}

function zoom_plus() {
	zoom += 0.5;
	if(zoom > 5) zoom = 5;
	ppmap.zoomMap(zoom);
}
function zoom_moins() {
	zoom -= 0.5;
	if(zoom < 0.5) zoom = 0.5;
	ppmap.zoomMap(zoom);
}

function IsNumeric(sText) {
	var ValidChars = "0123456789.";
	var IsNumber=true;
	var Char;
	for(i = 0; i < sText.length && IsNumber == true; i++){ 
		Char = sText.charAt(i); 
		if(ValidChars.indexOf(Char) == -1){
			IsNumber = false;
		}
	}
	return IsNumber;
}

function HTMLEncode(wText){
	if(typeof(wText)!="string"){
		wText=wText.toString();
	}
	wText=wText.replace(/&/g, "&amp;");
	wText=wText.replace(/"/g, "&quot;");
	wText=wText.replace(/</g, "&lt;");
	wText=wText.replace(/>/g, "&gt;");
	wText=wText.replace(/'/g, "&#146;");
	wText=wText.replace(/\n/g, "<br />");
	wText=wText.replace(/\t/g, "&nbsp;&nbsp;&nbsp;&nbsp;");
	return wText;
};

function save() {
	var monde = ppmap.getMonde();
	var monde_objets = ppmap.getObjects();
	
	var nl = "\n";
	var total = '<' + '?xml version="1.0" encoding="UTF-8"?' + '>' + nl;
	var total = total + '<map tile-width="64" tile-height="40" map-width="14" map-height="14">' + nl;
	var total = total + '	<map>' + nl;
	for(y = 1;y <= 14; y++) {
		for(x = 1;x <= 14; x++) {
			var total = total + '		<tile x="' + x + '" y="' + y + '" value="' + monde[x][y] + '" />' + nl;
		}
	}
	var total = total + '	</map>' + nl;
	var total = total + '	<objets>' + nl;
	
	var l = monde_objets.length;
	for(var i=0;i<l;i++) {
		var total = total + '		<objet id="' + monde_objets[i]['id'] + '" x="' + monde_objets[i]['x'] + '" y="' + monde_objets[i]['y'] + '" value="' + monde_objets[i]['sprite'] + '" />' + nl;
	}
	var total = total + '	</objets>' + nl;
	var total = total + '</map>' + nl;
	
	$('#show').html(HTMLEncode(total));
}

// --> </script>
<div class="copyright">pp3Diso : <a href="http://www.prelude-prod.fr/demo/pp3diso/">www.prelude-prod.fr/demo/pp3diso/</a><br />
Les images de cette d&eacute;monstration proviennent du programme <a href="http://code.google.com/p/jgen/">jgen</a>.</div>
<?php include '../../stat.inc.php'; ?>
</body>
</html>